package jadean.ui.java.wizards;

import jadean.dean.java.JavaProject;

import java.util.ArrayList;
import java.util.List;


public class WizardInput {
	private JavaProject project;
	private String path;
	private String entryPoint = null;
	private List<WizardInputChangedListener> listeners;
	
	public WizardInput(JavaProject project) {
		super();
		setProject(project);
	}
	
	public WizardInput() {
		this.listeners = new ArrayList<WizardInputChangedListener>();
	}

	public JavaProject getProject() {
		return project;
	}

	public void setProject(JavaProject project) {
		this.project = project;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public String getEntryPoint() {
		return entryPoint;
	}

	public void setEntryPoint(String entryPoint) {
		this.entryPoint = entryPoint;
	}
	
	public void addListener(WizardInputChangedListener wicl) {
		this.listeners.add(wicl);
	}
	
	public void notifyListeners() {
		for (WizardInputChangedListener wicl: listeners) {
			wicl.inputChanged();
		}
	}
}
